/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.bitbag.IBitBagAcceptingBlock;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.inventory.bit.SlottedBitInventoryItemStack;
import mod.chiselsandbits.network.packets.OpenBagGuiPacket;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.SimpleInstanceCache;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitBagItem
extends class_1792
implements IBitInventoryItem {
    private static final int BAG_STORAGE_SLOTS = 63;
    SimpleInstanceCache<class_1799, List<class_2561>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public BitBagItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        class_1767 color = BitBagItem.getDyedColor(stack);
        class_2561 parent = super.method_7864(stack);
        if (parent instanceof class_5250 && color != null) {
            return ((class_5250)parent).method_27693(" - ").method_10852((class_2561)new class_2588("chiselsandbits.color." + color.method_7792()));
        }
        return super.method_7864(stack);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        List<class_2561> details;
        super.method_7851(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpBitBag, tooltip, new Object[0]);
        if (this.tooltipCache.needsUpdate(stack)) {
            IBitInventoryItemStack inventoryItemStack = this.create(stack);
            this.tooltipCache.updateCachedValue(inventoryItemStack.listContents());
        }
        if ((details = this.tooltipCache.getCached()).size() <= 2 || class_310.method_1551().method_22683() != null && class_437.method_25442()) {
            tooltip.addAll(details);
        } else {
            tooltip.add((class_2561)LocalStrings.ShiftDetails.getText());
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, class_1657 playerIn, @NotNull class_1268 hand) {
        class_3965 blockRayTraceResult;
        class_2680 hitBlockState;
        class_239 rayTraceResult;
        class_1799 itemStackIn = playerIn.method_5998(hand);
        if (playerIn != null && (rayTraceResult = RayTracingUtils.rayTracePlayer(playerIn)).method_17783() == class_239.class_240.field_1332 && rayTraceResult instanceof class_3965 && (hitBlockState = worldIn.method_8320((blockRayTraceResult = (class_3965)rayTraceResult).method_17777())).method_26204() instanceof IBitBagAcceptingBlock) {
            ((IBitBagAcceptingBlock)hitBlockState.method_26204()).onBitBagInteraction(itemStackIn, playerIn, blockRayTraceResult);
            return new class_1271(class_1269.field_5812, (Object)itemStackIn);
        }
        if (worldIn.field_9236) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new OpenBagGuiPacket());
        }
        return new class_1271(class_1269.field_5812, (Object)itemStackIn);
    }

    @Override
    public IBitInventoryItemStack create(class_1799 stack) {
        if (stack.method_7909() != this) {
            return new SlottedBitInventoryItemStack(0, nbt -> class_1799.field_8037);
        }
        SlottedBitInventoryItemStack inventoryItemStack = new SlottedBitInventoryItemStack(63, nbt -> {
            stack.method_7948().method_10566("Inventory", (class_2520)nbt);
            return stack;
        });
        if (!stack.method_7948().method_10545("Inventory") && stack.method_7948().method_10545("contents")) {
            int[] legacyContentData = stack.method_7948().method_10561("contents");
            if (legacyContentData.length != 126) {
                int[] tmp = legacyContentData;
                legacyContentData = new int[126];
                System.arraycopy(legacyContentData, 0, tmp, 0, Math.min(126, tmp.length));
            }
            for (int i = 0; i < 63; ++i) {
                int count = legacyContentData[2 * i + 1];
                int id = legacyContentData[2 * i];
                class_2680 blockState = IBlockStateIdManager.getInstance().getBlockStateFrom(id);
                BlockInformation blockInformation = new BlockInformation(blockState);
                class_1799 bitStack = IBitItemManager.getInstance().create(blockInformation, count);
                inventoryItemStack.method_5447(i, bitStack);
            }
            stack.method_7948().method_10551("contents");
        }
        inventoryItemStack.deserializeNBT(stack.method_7911("Inventory"));
        return inventoryItemStack;
    }

    public boolean showDurabilityBar(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IBitInventoryItem)) {
            return false;
        }
        IBitInventoryItem item = (IBitInventoryItem)class_17922;
        IBitInventoryItemStack inventoryItemStack = item.create(stack);
        return !inventoryItemStack.method_5442();
    }

    public double getDurabilityForDisplay(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IBitInventoryItem)) {
            return 0.0;
        }
        IBitInventoryItem item = (IBitInventoryItem)class_17922;
        IBitInventoryItemStack inventoryItemStack = item.create(stack);
        double filledRatio = inventoryItemStack.getFilledRatio();
        return Math.min(1.0, Math.max(0.0, IClientConfiguration.getInstance().getInvertBitBagFullness().get() != false ? filledRatio : 1.0 - filledRatio));
    }

    public void method_7850(@NotNull class_1761 group, @NotNull class_2371<class_1799> items) {
        if (this.method_7877(group)) {
            if (this == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                items.add((Object)new class_1799((class_1935)this));
            } else {
                for (class_1767 color : class_1767.values()) {
                    items.add((Object)BitBagItem.dyeBag(new class_1799((class_1935)this), color));
                }
            }
        }
    }

    public static class_1799 dyeBag(class_1799 bag, class_1767 color) {
        class_1799 copy = bag.method_7972();
        if (!copy.method_7985()) {
            copy.method_7980(new class_2487());
        }
        if (color == null && bag.method_7909() == ModItems.ITEM_BIT_BAG_DYED.get()) {
            class_1799 unColoredStack = new class_1799((class_1935)ModItems.ITEM_BIT_BAG_DEFAULT.get());
            unColoredStack.method_7980(copy.method_7969());
            unColoredStack.method_7948().method_10551("color");
            return unColoredStack;
        }
        if (color != null) {
            class_1799 coloredStack = copy;
            if (coloredStack.method_7909() == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                coloredStack = new class_1799((class_1935)ModItems.ITEM_BIT_BAG_DYED.get());
                coloredStack.method_7980(copy.method_7969());
            }
            coloredStack.method_7948().method_10582("color", color.method_7792());
            return coloredStack;
        }
        return copy;
    }

    public static class_1767 getDyedColor(class_1799 stack) {
        if (stack.method_7909() != ModItems.ITEM_BIT_BAG_DYED.get()) {
            return null;
        }
        if (stack.method_7948().method_10545("color")) {
            String name = stack.method_7948().method_10558("color");
            for (class_1767 color : class_1767.values()) {
                if (!name.equals(color.method_15434())) continue;
                return color;
            }
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return false;
    }
}

